<?php $__env->startSection('styles'); ?>
    <!-- Add PDF and Excel libraries -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf-autotable/3.8.1/jspdf.plugin.autotable.min.js"></script>
    <script src="https://cdn.sheetjs.com/xlsx-0.20.1/package/dist/xlsx.full.min.js"></script>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <!--begin::App Main-->
    <main class="app-main">
        <!--begin::App Content Header-->
        <div class="app-content-header">
            <!--begin::Container-->
            <div class="container-fluid">
                <!--begin::Row-->
                <div class="row">
                    <div class="col-sm-6">
                        <h3 class="mb-0">Laporan WIWIK</h3>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-end">
                            <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>">Home</a></li>
                            <li class="breadcrumb-item active" aria-current="page">Laporan WIWIK</li>
                        </ol>
                    </div>
                </div>
                <!--end::Row-->
            </div>
            <!--end::Container-->
        </div>
        <!--end::App Content Header-->
        <!--begin::App Content-->
        <div class="app-content">
            <!--begin::Container-->
            <div class="container-fluid">
                <!--begin::Row-->
                <div class="row">
                    <div class="card">
                        <div class="card-header">
                            <div class="d-flex justify-content-between align-items-center">
                                <h3 class="card-title">Laporan WIWIK</h3>
                                <div>
                                    <button class="btn btn-success btn-sm" onclick="exportToExcel()">
                                        <i class="bi bi-file-earmark-excel"></i> Export Excel
                                    </button>
                                    <button class="btn btn-danger btn-sm" onclick="exportToPDF()">
                                        <i class="bi bi-file-earmark-pdf"></i> Export PDF
                                    </button>
                                </div>
                            </div>
                        </div>
                        <!-- /.card-header -->
                        <div class="card-body">
                            <table id="laporanTable" class="table table-bordered table-sm text-center align-middle">
                                <div class="card-header" align="center">
                                    TOTAL STOK BOX EXPORT WIWIK<br>
                                    PER TANGGAL 14 AGUSTUS 2025
                                </div>
                                <thead class="table-secondary">
                                    <tr>
                                        <th rowspan="2">CUSTOMER</th>
                                        <th rowspan="2">GRADE</th>
                                        <th colspan="14">TAKAYAMA</th>
                                        <th colspan="2">TOTAL</th>
                                        <th colspan="2">GRAND TOTAL</th>
                                    </tr>
                                    <tr>
                                        <th colspan="2">TAKAYAMA PUTIH</th>
                                        <th colspan="2">TAKAYAMA 3 kg</th>
                                        <th colspan="2">TAKAYAMA HITAM</th>
                                        <th colspan="2">TAKAYAMA HIJAU</th>
                                        <th colspan="2">TAKAYAMA PABRIK</th>
                                        <th colspan="2">KING CHARCOAL</th>
                                        <th colspan="2">MOOMIN</th>
                                        <th>BOX</th>
                                        <th>CONT</th>
                                        <th>BOX</th>
                                        <th>CONT</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td rowspan="10">MENGANTI</td>
                                        <td>AB</td>
                                        <td>0</td>
                                        <td>0.00</td>
                                        <td>0</td>
                                        <td>0.00</td>
                                        <td>0</td>
                                        <td>0.00</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>0</td>
                                        <td>0.00</td>
                                        <td rowspan="10">40.152</td>
                                        <td rowspan="10">14.73</td>
                                    </tr>
                                    <tr>
                                        <td>ABC</td>
                                        <td>0</td>
                                        <td>0.00</td>
                                        <td>0</td>
                                        <td>0.00</td>
                                        <td>0</td>
                                        <td>0.00</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>3.083</td>
                                        <td>1.3</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>155</td>
                                        <td>0.1</td>
                                        <td>3.238</td>
                                        <td>1.41</td>
                                    </tr>
                                    <tr>
                                        <td>BC</td>
                                        <td>0</td>
                                        <td>0.00</td>
                                        <td>0</td>
                                        <td>0.00</td>
                                        <td>0</td>
                                        <td>0.00</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>0</td>
                                        <td>0.00</td>
                                    </tr>
                                    <tr>
                                        <td>BCD</td>
                                        <td>0</td>
                                        <td>0.00</td>
                                        <td>0</td>
                                        <td>0.00</td>
                                        <td>0</td>
                                        <td>0.00</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>0</td>
                                        <td>0.00</td>
                                    </tr>
                                    <tr>
                                        <td>CDOC</td>
                                        <td>0</td>
                                        <td>0.00</td>
                                        <td>0</td>
                                        <td>0.00</td>
                                        <td>0</td>
                                        <td>0.00</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>0</td>
                                        <td>0.00</td>
                                    </tr>
                                    <tr>
                                        <td>CD</td>
                                        <td>0</td>
                                        <td>0.00</td>
                                        <td>0</td>
                                        <td>0.00</td>
                                        <td>0</td>
                                        <td>0.00</td>
                                        <td>-</td>
                                        <td>2.362</td>
                                        <td>1.0</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>2.362</td>
                                        <td>0.96</td>
                                    </tr>
                                    <tr>
                                        <td>AB</td>
                                        <td>0</td>
                                        <td>0.00</td>
                                        <td>0</td>
                                        <td>0.00</td>
                                        <td>0</td>
                                        <td>0</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>0</td>
                                        <td>0.00</td>
                                    </tr>
                                    <tr>
                                        <td>BC</td>
                                        <td>0</td>
                                        <td>0.00</td>
                                        <td>0</td>
                                        <td>0.00</td>
                                        <td>0</td>
                                        <td>0</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>0</td>
                                        <td>0.00</td>
                                    </tr>
                                    <tr>
                                        <td>BCD</td>
                                        <td>0</td>
                                        <td>0.00</td>
                                        <td>3445</td>
                                        <td>1.26</td>
                                        <td>0</td>
                                        <td>0</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>3.445</td>
                                        <td>1.26</td>
                                    </tr>
                                    <tr>
                                        <td>CDOC</td>
                                        <td>0</td>
                                        <td>0.12</td>
                                        <td>338</td>
                                        <td>0.00</td>
                                        <td>0</td>
                                        <td>0</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>338</td>
                                        <td>0.12</td>
                                    </tr>
                                    <tr>
                                        <td rowspan="7">BANJAR</td>
                                        <td>OC</td>
                                        <td>0</td>
                                        <td>0.00</td>
                                        <td>0</td>
                                        <td>0.00</td>
                                        <td>0</td>
                                        <td>0</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>0</td>
                                        <td>0.00</td>
                                        <td rowspan="7">22.284</td>
                                        <td rowspan="7">9.22</td>
                                    </tr>
                                    <tr>
                                        <td>CD</td>
                                        <td>0</td>
                                        <td>0.00</td>
                                        <td>0</td>
                                        <td>0.00</td>
                                        <td>0</td>
                                        <td>0.00</td>
                                        <td>-</td>
                                        <td>1.832</td>
                                        <td>0.7</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>1.832</td>
                                        <td>0.75</td>
                                    </tr>
                                    <tr>
                                        <td>AB</td>
                                        <td>0</td>
                                        <td>0.00</td>
                                        <td>0</td>
                                        <td>0.00</td>
                                        <td>0</td>
                                        <td>0</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>0</td>
                                        <td>0.00</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>0</td>
                                        <td>0.00</td>
                                    </tr>
                                    <tr>
                                        <td>ABC</td>
                                        <td>0</td>
                                        <td>0.00</td>
                                        <td>0</td>
                                        <td>0.00</td>
                                        <td>0</td>
                                        <td>0</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>491</td>
                                        <td>0.20</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>491</td>
                                        <td>0.20</td>
                                    </tr>
                                    <tr>
                                        <td>BC</td>
                                        <td>0</td>
                                        <td>0.00</td>
                                        <td>0</td>
                                        <td>0.00</td>
                                        <td>0</td>
                                        <td>0</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>0</td>
                                        <td>0.00</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>0</td>
                                        <td>0.00</td>
                                    </tr>
                                    <tr>
                                        <td>BCD</td>
                                        <td>0</td>
                                        <td>0.00</td>
                                        <td>395</td>
                                        <td>0.14</td>
                                        <td>0</td>
                                        <td>0</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>0</td>
                                        <td>0.00</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>395</td>
                                        <td>0.14</td>
                                    </tr>
                                    <tr>
                                        <td>OC</td>
                                        <td>0</td>
                                        <td>0.00</td>
                                        <td>0</td>
                                        <td>0.00</td>
                                        <td>0</td>
                                        <td>0</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>0</td>
                                        <td>0.00</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>0</td>
                                        <td>0.00</td>
                                    </tr>
                                    <tr>
                                        <td rowspan="6">PASURUAN</td>
                                        <td>CDOC</td>
                                        <td>0</td>
                                        <td>0.00</td>
                                        <td>4.500</td>
                                        <td>1.65</td>
                                        <td>0</td>
                                        <td>0</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>0</td>
                                        <td>0.00</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>4.500</td>
                                        <td>1.65</td>
                                        <td rowspan="6">10.506</td>
                                        <td rowspan="6">4.09</td>
                                    </tr>
                                    <tr>
                                        <td>CD</td>
                                        <td>0</td>
                                        <td>0.00</td>
                                        <td>0</td>
                                        <td>0.00</td>
                                        <td>0</td>
                                        <td>0</td>
                                        <td>-</td>
                                        <td>5.120</td>
                                        <td>2.09</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>5.120</td>
                                        <td>2.09</td>
                                    </tr>
                                    <tr>
                                        <td>A</td>
                                        <td>0</td>
                                        <td>0.00</td>
                                        <td>0</td>
                                        <td>0.00</td>
                                        <td>0</td>
                                        <td>0</td>
                                        <td>759</td>
                                        <td>0.3</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>759</td>
                                        <td>0.31</td>
                                    </tr>
                                    <tr>
                                        <td>AB</td>
                                        <td>0</td>
                                        <td>0.8371</td>
                                        <td>2281</td>
                                        <td>0.00</td>
                                        <td>0</td>
                                        <td>0</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>2.281</td>
                                        <td>0.84</td>
                                    </tr>
                                    <tr>
                                        <td>ABC</td>
                                        <td>0</td>
                                        <td>0.00</td>
                                        <td>0</td>
                                        <td>0.00</td>
                                        <td>0</td>
                                        <td>0.02</td>
                                        <td>56</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>1.253</td>
                                        <td>0.5</td>
                                        <td>-</td>
                                        <td>72</td>
                                        <td>0.1</td>
                                        <td>3.705</td>
                                        <td>1.55</td>
                                    </tr>
                                    <tr>
                                        <td>BC</td>
                                        <td>0</td>
                                        <td>0.00</td>
                                        <td>0</td>
                                        <td>0.00</td>
                                        <td>0</td>
                                        <td>0</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>0</td>
                                        <td>0.00</td>
                                    </tr>
                                    <tr>
                                        <td rowspan="2">SORONG</td>
                                        <td>BCD</td>
                                        <td>0</td>
                                        <td>0.00</td>
                                        <td>1456</td>
                                        <td>0.53</td>
                                        <td>0</td>
                                        <td>0</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>1.456</td>
                                        <td>0.53</td>
                                        <td rowspan="2">435</td>
                                        <td rowspan="2">0.16</td>
                                    </tr>
                                    <tr>
                                        <td>CD</td>
                                        <td>0</td>
                                        <td>0.00</td>
                                        <td>0</td>
                                        <td>0.00</td>
                                        <td>0</td>
                                        <td>0</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>1.970</td>
                                        <td>0.8</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>1.970</td>
                                        <td>0.80</td>
                                    </tr>
                                    <tr>
                                        <td rowspan="8">LAMONGAN</td>
                                        <td>CDOC</td>
                                        <td>0</td>
                                        <td>0.47</td>
                                        <td>1.288</td>
                                        <td>0.00</td>
                                        <td>0</td>
                                        <td>1.288</td>
                                        <td>0.47</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>1.288</td>
                                        <td>0.47</td>
                                        <td rowspan="8">11.459</td>
                                        <td rowspan="8">4.51</td>
                                    </tr>
                                    <tr>
                                        <td>AB</td>
                                        <td>146</td>
                                        <td>0.06</td>
                                        <td>0</td>
                                        <td>0.00</td>
                                        <td>0</td>
                                        <td>0.00</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>146</td>
                                        <td>0.06</td>
                                    </tr>
                                    <tr>
                                        <td>ABC</td>
                                        <td>0</td>
                                        <td>0.00</td>
                                        <td>0</td>
                                        <td>0.00</td>
                                        <td>0</td>
                                        <td>0.00</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>0</td>
                                        <td>0.00</td>
                                    </tr>
                                    <tr>
                                        <td>ABCD</td>
                                        <td>0</td>
                                        <td>0.00</td>
                                        <td>0</td>
                                        <td>0.00</td>
                                        <td>293</td>
                                        <td>0.11</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>293</td>
                                        <td>0.11</td>
                                    </tr>
                                    <tr>
                                        <td>BC</td>
                                        <td>0</td>
                                        <td>0.00</td>
                                        <td>0</td>
                                        <td>0.00</td>
                                        <td>0</td>
                                        <td>0.00</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>0</td>
                                        <td>0.00</td>
                                    </tr>
                                    <tr>
                                        <td>BCD</td>
                                        <td>0</td>
                                        <td>0.00</td>
                                        <td>2.925</td>
                                        <td>1.07</td>
                                        <td>0</td>
                                        <td>0.00</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>2.925</td>
                                        <td>1.07</td>
                                    </tr>
                                    <tr>
                                        <td>OC</td>
                                        <td>0</td>
                                        <td>0.00</td>
                                        <td>0</td>
                                        <td>0.00</td>
                                        <td>0</td>
                                        <td>0.00</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>0</td>
                                        <td>0.00</td>
                                    </tr>
                                    <tr>
                                        <td>CD</td>
                                        <td>0</td>
                                        <td>0.00</td>
                                        <td>0</td>
                                        <td>0.00</td>
                                        <td>0</td>
                                        <td>0.00</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>72</td>
                                        <td>0.03</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>72</td>
                                        <td>0.03</td>
                                    </tr>
                                    <tr>
                                        <td rowspan="8">TOMATO SEMARANG</td>
                                        <td>CDOC</td>
                                        <td>0</td>
                                        <td>0.10</td>
                                        <td>269</td>
                                        <td>0.00</td>
                                        <td>0</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>0</td>
                                        <td>0.00</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>269</td>
                                        <td>0.10</td>
                                        <td rowspan="8">5.813</td>
                                        <td rowspan="8">2.37</td>
                                    </tr>
                                    <tr>
                                        <td>A</td>
                                        <td>0</td>
                                        <td>0.00</td>
                                        <td>0</td>
                                        <td>0.00</td>
                                        <td>0</td>
                                        <td>76</td>
                                        <td>0.0</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>76</td>
                                        <td>0.03</td>
                                    </tr>
                                    <tr>
                                        <td>AB</td>
                                        <td>0</td>
                                        <td>1.76</td>
                                        <td>4.805</td>
                                        <td>0.00</td>
                                        <td>-</td>
                                        <td>0.00</td>
                                        <td>0</td>
                                        <td>-</td>
                                        <td>0</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>4.805</td>
                                        <td>1.76</td>
                                    </tr>
                                    <tr>
                                        <td>ABC</td>
                                        <td>0</td>
                                        <td>0.00</td>
                                        <td>-</td>
                                        <td>0.00</td>
                                        <td>-</td>
                                        <td>0.00</td>
                                        <td>0</td>
                                        <td>1.898</td>
                                        <td>0.70</td>
                                        <td>-</td>
                                        <td>2.452</td>
                                        <td>1.0</td>
                                        <td>1</td>
                                        <td>0.0</td>
                                        <td>4.351</td>
                                        <td>1.70</td>
                                    </tr>
                                    <tr>
                                        <td>ABC PSN</td>
                                        <td>0</td>
                                        <td>0.00</td>
                                        <td>-</td>
                                        <td>0.00</td>
                                        <td>-</td>
                                        <td>0.00</td>
                                        <td>0</td>
                                        <td>393</td>
                                        <td>0.14</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>0</td>
                                        <td>-</td>
                                        <td>393</td>
                                        <td>0.14</td>
                                    </tr>
                                    <tr>
                                        <td>ABCD</td>
                                        <td>0</td>
                                        <td>0.00</td>
                                        <td>-</td>
                                        <td>0.00</td>
                                        <td>-</td>
                                        <td>0.00</td>
                                        <td>4.907</td>
                                        <td>1.80</td>
                                        <td>-</td>
                                        <td>0</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>0</td>
                                        <td>-</td>
                                        <td>4.907</td>
                                        <td>1.80</td>
                                    </tr>
                                    <tr>
                                        <td>BC</td>
                                        <td>0</td>
                                        <td>0.00</td>
                                        <td>-</td>
                                        <td>0.00</td>
                                        <td>-</td>
                                        <td>0.00</td>
                                        <td>0</td>
                                        <td>-</td>
                                        <td>0</td>
                                        <td>-</td>
                                        <td>63</td>
                                        <td>0.0</td>
                                        <td>0</td>
                                        <td>-</td>
                                        <td>63</td>
                                        <td>0.03</td>
                                    </tr>
                                    <tr>
                                        <td>BCD</td>
                                        <td>0</td>
                                        <td>0.00</td>
                                        <td>0</td>
                                        <td>0.00</td>
                                        <td>3151</td>
                                        <td>1.16</td>
                                        <td>0</td>
                                        <td>-</td>
                                        <td>0</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>0</td>
                                        <td>-</td>
                                        <td>3.151</td>
                                        <td>1.16</td>
                                    </tr>
                                    <tr>
                                        <td rowspan="5">TRANSIT SORONG</td>
                                        <td>CD</td>
                                        <td>0</td>
                                        <td>0.00</td>
                                        <td>0</td>
                                        <td>0.51</td>
                                        <td>1384</td>
                                        <td>0.00</td>
                                        <td>0</td>
                                        <td>-</td>
                                        <td>0</td>
                                        <td>-</td>
                                        <td>149</td>
                                        <td>0.1</td>
                                        <td>0</td>
                                        <td>-</td>
                                        <td>1.533</td>
                                        <td>0.57</td>
                                        <td rowspan="5">5.615</td>
                                        <td rowspan="5">2.14</td>
                                    </tr>
                                    <tr>
                                        <td>CDOC</td>
                                        <td>0</td>
                                        <td>0.00</td>
                                        <td>0</td>
                                        <td>0.06</td>
                                        <td>170</td>
                                        <td>0.00</td>
                                        <td>0</td>
                                        <td>-</td>
                                        <td>0</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>0</td>
                                        <td>-</td>
                                        <td>170</td>
                                        <td>0.06</td>
                                    </tr>
                                    <tr>
                                        <td>AB</td>
                                        <td>0</td>
                                        <td>0.00</td>
                                        <td>0</td>
                                        <td>0.00</td>
                                        <td>0</td>
                                        <td>0</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>0</td>
                                        <td>0.00</td>
                                    </tr>
                                    <tr>
                                        <td>BC</td>
                                        <td>0</td>
                                        <td>0.00</td>
                                        <td>0</td>
                                        <td>0.00</td>
                                        <td>0</td>
                                        <td>0</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>0</td>
                                        <td>0.00</td>
                                    </tr>
                                    <tr>
                                        <td>BCD</td>
                                        <td>0</td>
                                        <td>0.00</td>
                                        <td>5763</td>
                                        <td>2.11</td>
                                        <td>0</td>
                                        <td>0</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>5.763</td>
                                        <td>2.11</td>
                                    </tr>
                                    <tr>
                                        <td rowspan="4">SORONG</td>
                                        <td>OC</td>
                                        <td>0</td>
                                        <td>0.00</td>
                                        <td>0</td>
                                        <td>0.00</td>
                                        <td>0</td>
                                        <td>0</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>0</td>
                                        <td>0.00</td>
                                        <td rowspan="4">435</td>
                                        <td rowspan="4">0.16</td>
                                    </tr>
                                    <tr>
                                        <td>CD</td>
                                        <td>0</td>
                                        <td>0.00</td>
                                        <td>0</td>
                                        <td>0.00</td>
                                        <td>0</td>
                                        <td>0</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>50</td>
                                        <td>0.0</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>50</td>
                                        <td>0.02</td>
                                    </tr>
                                    <tr>
                                        <td>CDOC</td>
                                        <td>0</td>
                                        <td>0.00</td>
                                        <td>0</td>
                                        <td>0.00</td>
                                        <td>0</td>
                                        <td>0</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>0</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>0</td>
                                        <td>0.00</td>
                                    </tr>
                                    <tr>
                                        <td>AB</td>
                                        <td>0</td>
                                        <td>0.00</td>
                                        <td>0</td>
                                        <td>0.00</td>
                                        <td>0</td>
                                        <td>0</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>0</td>
                                        <td>0.00</td>
                                    </tr>
                                    <tr>
                                        <td>TRANSIT SORONG</td>
                                        <td>ABC</td>
                                        <td>0</td>
                                        <td>0.00</td>
                                        <td>0</td>
                                        <td>0.00</td>
                                        <td>0</td>
                                        <td>0.159633</td>
                                        <td>435</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>435</td>
                                        <td>0.16</td>
                                        <td></td>
                                        <td></td>
                                    </tr>
                                    <tr>
                                        <td>TRANSIT BC</td>
                                        <td>BC</td>
                                        <td>0</td>
                                        <td>0.00</td>
                                        <td>0</td>
                                        <td>0.00</td>
                                        <td>0</td>
                                        <td>0</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>0</td>
                                        <td>0.00</td>
                                        <td></td>
                                        <td></td>
                                    </tr>
                                    <tr>
                                        <td>SORONG OC</td>
                                        <td>OC</td>
                                        <td>0</td>
                                        <td>0.00</td>
                                        <td>0</td>
                                        <td>0.00</td>
                                        <td>0</td>
                                        <td>0</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>0</td>
                                        <td>0.00</td>
                                        <td></td>
                                        <td></td>
                                    </tr>
                                    <tr>
                                        <td>CD</td>
                                        <td>CD</td>
                                        <td>0</td>
                                        <td>0.00</td>
                                        <td>0</td>
                                        <td>0.00</td>
                                        <td>0</td>
                                        <td>0</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>-</td>
                                        <td>0</td>
                                        <td>0.00</td>
                                        <td></td>
                                        <td></td>
                                    </tr>
                                </tbody>
                                <tfoot class="table-secondary fw-bold">
                                    <tr>
                                        <td colspan="2">TOTAL</td>
                                        <td>146</td>
                                        <td>0.06</td>
                                        <td>7.086</td>
                                        <td>2.60</td>
                                        <td>7.949</td>
                                        <td>2.92</td>
                                        <td>17.135</td>
                                        <td>6.29</td>
                                        <td>5.200</td>
                                        <td>1.91</td>
                                        <td>2.782</td>
                                        <td>1.02</td>
                                        <td>835</td>
                                        <td>0.34</td>
                                        <td>62.582</td>
                                        <td>24.01</td>
                                        <td>62.582</td>
                                        <td>24.01</td>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>


                        <!-- /.card-body -->
                        <div class="card-footer clearfix">
                            <ul class="pagination pagination-sm m-0 float-end">
                                <li class="page-item"><a class="page-link" href="#">&laquo;</a></li>
                                <li class="page-item"><a class="page-link" href="#">1</a></li>
                                <li class="page-item"><a class="page-link" href="#">2</a></li>
                                <li class="page-item"><a class="page-link" href="#">3</a></li>
                                <li class="page-item"><a class="page-link" href="#">&raquo;</a></li>
                            </ul>
                        </div>
                        <!-- /.card -->
                    </div>
                </div>
                <!--end::Row-->
            </div>
            <!--end::Container-->
        </div>
        <!--end::App Content-->
    </main>
    <!--end::App Main-->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('jsscript'); ?>
    <!--begin::Script-->
    <!--begin::Third Party Plugin(OverlayScrollbars)-->
    <script src="https://cdn.jsdelivr.net/npm/overlayscrollbars@2.11.0/browser/overlayscrollbars.browser.es6.min.js"
        crossorigin="anonymous"></script>
    <!--end::Third Party Plugin(OverlayScrollbars)--><!--begin::Required Plugin(popperjs for Bootstrap 5)-->
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.8/dist/umd/popper.min.js" crossorigin="anonymous">
    </script>
    <!--end::Required Plugin(popperjs for Bootstrap 5)--><!--begin::Required Plugin(Bootstrap 5)-->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.7/dist/js/bootstrap.min.js" crossorigin="anonymous"></script>
    <!--end::Required Plugin(Bootstrap 5)--><!--begin::Required Plugin(AdminLTE)-->
    <script src="../js/adminlte.js"></script>
    <!--end::Required Plugin(AdminLTE)--><!--begin::OverlayScrollbars Configure-->
    <script>
        const SELECTOR_SIDEBAR_WRAPPER = '.sidebar-wrapper';
        const Default = {
            scrollbarTheme: 'os-theme-light',
            scrollbarAutoHide: 'leave',
            scrollbarClickScroll: true,
        };
        document.addEventListener('DOMContentLoaded', function() {
            const sidebarWrapper = document.querySelector(SELECTOR_SIDEBAR_WRAPPER);
            if (sidebarWrapper && OverlayScrollbarsGlobal?.OverlayScrollbars !== undefined) {
                OverlayScrollbarsGlobal.OverlayScrollbars(sidebarWrapper, {
                    scrollbars: {
                        theme: Default.scrollbarTheme,
                        autoHide: Default.scrollbarAutoHide,
                        clickScroll: Default.scrollbarClickScroll,
                    },
                });
            }
        });
    </script>
    <!--end::OverlayScrollbars Configure-->
    <script>
        function exportToExcel() {
            const table = document.querySelector('table');
            const wb = XLSX.utils.table_to_book(table, {
                sheet: "TOTAL STOK BOX EXPORT WIWIK"
            });
            XLSX.writeFile(wb, 'Laporan_WIWIK.xlsx');
        }

        function exportToPDF() {
            const {
                jsPDF
            } = window.jspdf;
            const doc = new jsPDF('l', 'pt', 'a4');

            // Add title
            doc.setFontSize(18);
            doc.text('TOTAL STOK BOX EXPORT WIWIK ', 40, 40);

            // Add the table
            doc.autoTable({
                html: 'table',
                startY: 50,
                theme: 'grid',
                headStyles: {
                    fillColor: [169, 169, 169]
                },
                columnStyles: {
                    0: {
                        cellWidth: 60
                    },
                    1: {
                        cellWidth: 40
                    }
                },
                didDrawPage: function(data) {
                    // Add footer
                    doc.setFontSize(10);
                    doc.text('Page ' + doc.internal.getNumberOfPages(), data.settings.margin.left, doc.internal
                        .pageSize.height - 10);
                }
            });

            // Save the PDF
            doc.save('Laporan_WIWIK.pdf');
        }
    </script>
    <!--end::Script-->
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.main', ['title' => 'Tuju Kuda - Laporan WIWIK'], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\Web\lara-odoo\odoo18\resources\views/report/laporan-wiwik.blade.php ENDPATH**/ ?>