import requests
import time
from datetime import datetime, timedelta
from zoneinfo import ZoneInfo

API_URL = "http://127.0.0.1:8000/api/machine-readings"
WIB = ZoneInfo("Asia/Jakarta")

def send_reading(name, amp, temp, moist, hm, ts=None):
    if ts is None:
        ts = datetime.now(WIB)
        
    payload = {
        "machine_id": name,
        "amp": amp,
        "temp": temp,
        "moist": moist,
        "hm": hm,
        "timestamp": ts.isoformat()
    }
    try:
        res = requests.post(API_URL, json=payload, timeout=5)
        print(f"[{res.status_code}] Sent {name:15} | TS: {ts.strftime('%H:%M:%S')} | Amp: {amp:5.2f} | Temp: {temp:5.2f}")
    except Exception as e:
        print(f"Error sending {name}: {e}")

def run_test():
    now = datetime.now(WIB)
    
    print("=" * 70)
    print("🚀 INJECTING DATA FOR RANGE TESTING (SUMMARY & CUSTOM)")
    print("=" * 70)
    
    # 1. Data untuk "Last 1 Hour" (Summary default)
    print("\n--- Sending data for [NOW] (Last 1 Hour) ---")
    send_reading("M-NOW-1", 12.0, 75.0, 30.0, 100.0, now - timedelta(minutes=5))
    send_reading("M-NOW-2", 25.0, 60.0, 20.0, 200.0, now - timedelta(minutes=10))

    # 2. Data untuk "Last 4 Hours" (Summary 4h)
    print("\n--- Sending data for [3 HOURS AGO] (Visible in 4h/8h/etc) ---")
    send_reading("M-PAST-3H", 30.0, 85.0, 50.0, 500.0, now - timedelta(hours=3))

    # 3. Data untuk "Yesterday" (Hanya muncul di Custom Range)
    print("\n--- Sending data for [YESTERDAY] (Custom Range only) ---")
    yesterday = now - timedelta(days=1)
    send_reading("M-YESTERDAY", 40.0, 50.0, 10.0, 999.0, yesterday)

    print("\n" + "=" * 70)
    print("✅ TEST DATA INJECTED!")
    print("\nCARA TESTING:")
    print("1. Cek mode 'Summary (4 Jam)':")
    print("   - M-NOW-1 (paling atas karena Amp < 14) dan M-NOW-2 HARUS muncul.")
    print("   - M-PAST-3H HARUS muncul.")
    print("   - M-YESTERDAY TIDAK BOLEH muncul.")
    print("\n2. Cek mode 'Custom Range' (pilih tanggal kemarin s/d hari ini):")
    print("   - M-YESTERDAY HARUS muncul.")
    print("=" * 70)

if __name__ == "__main__":
    run_test()
