import requests
import json

API_URL = "http://127.0.0.1:8000/api/machine-readings"

def test_api(name, payload):
    print(f"--- Case: {name} ---")
    headers = {'Accept': 'application/json'}
    try:
        res = requests.post(API_URL, json=payload, headers=headers, timeout=5)
        print(f"Status: {res.status_code}")
        try:
            print(f"Response: {json.dumps(res.json(), indent=2)}")
        except:
            print(f"Response: {res.text}")
    except Exception as e:
        print(f"Error: {e}")
    print("-" * 30)

def run_tests():
    print("🚀 Running API Validation Tests...\n")

    # 1. Missing Machine ID
    test_api("TC-5.1: Missing machine_id", {
        "amp": 20.0, "hm": 1000, "temp": 60.0, "moist": 20.0
    })

    # 2. Missing Amp
    test_api("TC-5.2: Missing amp value", {
        "machine_id": "ERR-TEST", "hm": 1000, "temp": 60.0, "moist": 20.0
    })

    # 3. Invalid Data Type (String for Temp)
    test_api("TC-5.3: String instead of Number (temp='HOT')", {
        "machine_id": "ERR-TEST", "amp": 20, "hm": 1000, "temp": "HOT", "moist": 20.0
    })

    # 4. Empty Payload
    test_api("TC-5.4: Empty JSON Object", {})

    # 5. Extra Field (Should be Success & Ignored)
    test_api("TC-5.5: Extra unknown field (success expected)", {
        "machine_id": "SAFE-TEST", "amp": 20, "hm": 1000, "temp": 60.0, "moist": 20.0,
        "super_secret_field": "ignore me"
    })

if __name__ == "__main__":
    run_tests()
