import requests
import time
import random
from datetime import datetime
from zoneinfo import ZoneInfo

# Konfigurasi
API_URL = "http://127.0.0.1:8000/api/machine-readings"
NUM_MACHINES = 24
INTERVAL_SECONDS = 10
WIB = ZoneInfo("Asia/Jakarta")

def generate_sensor_data(machine_id):
    now_wib = datetime.now(WIB)

    return {
        "machine_id": f"MESIN-{machine_id:02d}",
        "amp": round(random.uniform(5.0, 20.0), 2),
        "hm": round(random.uniform(1000.0, 5000.0), 1),
        "temp": round(random.uniform(40.0, 70.0), 2),
        "moist": round(random.uniform(5.0, 50.0), 2),
        "timestamp": now_wib.isoformat()  # WIB with timezone info
    }

def run_simulation():
    print(f"🚀 Simulasi {NUM_MACHINES} mesin (WIB)")
    print("-" * 50)

    try:
        while True:
            for i in range(1, NUM_MACHINES + 1):
                payload = generate_sensor_data(i)
                try:
                    response = requests.post(API_URL, json=payload, timeout=5)
                    if response.status_code == 201:
                        print(f"✅ [{payload['timestamp']}] {payload['machine_id']} terkirim")
                    else:
                        print(f"❌ {payload['machine_id']} GAGAL ({response.status_code})")
                except requests.exceptions.RequestException as e:
                    print(f"⚠️ Error {payload['machine_id']}: {e}")

            time.sleep(INTERVAL_SECONDS)

    except KeyboardInterrupt:
        print("\n🛑 Simulasi dihentikan")

if __name__ == "__main__":
    run_simulation()
